<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Title', 'h3', 'layout_one');

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Contact', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
