<?php
$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_post_count',
    [
        'label' => __('Number Of Posts', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 0,
                'max' => 11,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 6,
        ],
    ]
);

$this->add_control(
    'layout_two_select_category',
    [
        'label' => __('Product Category', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => hostom_get_taxonoy('product_cat'),
    ]
);


$this->add_control(
    'layout_two_query_order',
    [
        'label' => __('Select Order', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => 'DESC',
        'options' => [
            'DESC' => __('DESC', 'hostom-addon'),
            'ASC' => __('ASC', 'hostom-addon'),
        ]
    ]
);

$this->end_controls_section();
