<?php

$this->start_controls_section(
    'content_section_three',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_three');

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_three');

$service_list_three = new \Elementor\Repeater();

$service_list_three->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($service_list_three, 'Service Title', 'h3', 'layout_three');

$service_list_three->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$service_list_three->add_control(
    'summary',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary text', 'hostom-addon'),
        'default' => __('Default Summary text', 'hostom-addon'),
    ]
);


$service_list_three->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-firewall-1',
            'library' => 'custom-icon',
        ],
    ]
);

$service_list_three->add_control(
    'bg_image',
    [
        'label' => __('Background Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ]
    ]
);

$this->add_control(
    'service_list_three',
    [
        'label' => __('Service Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $service_list_three->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_three_bg_image',
    [
        'label' => __('Background Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => []
    ]
);

$this->end_controls_section();
