<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$progress_bar = new \Elementor\Repeater();

$progress_bar->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Progress Nar title', 'hostom-addon'),
        'default' => __('Counseling', 'hostom-addon'),
        'label_block' => true
    ]
);

hostom_elementor_heading_option($progress_bar, 'Title', 'h4', 'layout_one');

$progress_bar->add_control(
    'progress_count',
    [
        'label' => __('Progress Bar Count', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 90,
        ],
    ]
);

$this->add_control(
    'progress_bar',
    [
        'label' => __('Progress Bar Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $progress_bar->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
