<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Pricing Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_two');
$this->add_control(
    'layout_two_monthly_heading',
    [
        'label' => __('Monthly Heading', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Monthly', 'hostom-addon'),
        'default' => __('Monthly', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_two_yearly_heading',
    [
        'label' => __('Yearly Heading', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Yearly', 'hostom-addon'),
        'default' => __('Yearly', 'hostom-addon'),
    ]
);

$layout_two_pricing_monthly_list = new \Elementor\Repeater();

$layout_two_pricing_monthly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'plan_type',
    [
        'label' => __('Plan Type', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Starting', 'hostom-addon'),
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$50.00', 'hostom-addon'),
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'duration',
    [
        'label' => __('Duration', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Per Month', 'hostom-addon'),
    ]
);


$layout_two_pricing_monthly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li class="package-card__content__list__item">1 Website</li>', 'hostom_allowed_tags')
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$layout_two_pricing_monthly_list->add_control(
    'shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_two_pricing_monthly_list',
    [
        'label' => __('Monthly List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_pricing_monthly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->add_control(
    'pricing_layout_two_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$layout_two_pricing_yearly_list = new \Elementor\Repeater();

$layout_two_pricing_yearly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$layout_two_pricing_yearly_list->add_control(
    'plan_type',
    [
        'label' => __('Plan Type', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Starting', 'hostom-addon'),
    ]
);

$layout_two_pricing_yearly_list->add_control(
    'price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$50.00', 'hostom-addon'),
    ]
);

$layout_two_pricing_yearly_list->add_control(
    'duration',
    [
        'label' => __('Duration', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Per Month', 'hostom-addon'),
    ]
);


$layout_two_pricing_yearly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li class="package-card__content__list__item">1 Website</li>', 'hostom_allowed_tags')
    ]
);


$layout_two_pricing_yearly_list->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_two_pricing_yearly_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$layout_two_pricing_yearly_list->add_control(
    'shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_two_pricing_yearly_list',
    [
        'label' => __('Yearly List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_pricing_yearly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->add_control(
    'layout_two_bg_image',
    [
        'label' => __('Background Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
