<?php

$this->start_controls_section(
    'content_section_three',
    [
        'label' => __('Pricing Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);


$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);


$layout_three_features = new \Elementor\Repeater();

$layout_three_features->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_features',
    [
        'label' => __('Features List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_features->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_three_package_one',
    [
        'label' => __('Package One', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_package_one_title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_package_one_price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('$60.00', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_package_one_duration',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Per Month', 'hostom-addon'),
    ]
);

$layout_three_package_one_features_availability = new \Elementor\Repeater();

$layout_three_package_one_features_availability->add_control(
    'is_available',
    [
        'label' => __('Is this feature availabe?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'layout_three_package_one_features_availability',
    [
        'label' => __('Features List Availability', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_package_one_features_availability->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->add_control(
    'layout_three_package_one_button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Select Plan', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_package_one_button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'layout_three_package_one_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();


$this->start_controls_section(
    'layout_three_package_two',
    [
        'label' => __('Package Two', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_package_two_title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_package_two_price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('$60.00', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_package_two_duration',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Per Month', 'hostom-addon'),
    ]
);

$layout_three_package_two_features_availability = new \Elementor\Repeater();

$layout_three_package_two_features_availability->add_control(
    'is_available',
    [
        'label' => __('Is this feature availabe?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'layout_three_package_two_features_availability',
    [
        'label' => __('Features List Availability', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_package_two_features_availability->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->add_control(
    'layout_three_package_two_button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Select Plan', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_package_two_button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'layout_three_package_two_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
