<?php

$this->start_controls_section(
    'layout_five_content_section',
    [
        'label' => __('Pricing Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);

$layout_five_pricing_list = new \Elementor\Repeater();

$layout_five_pricing_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Cloud Hosting', 'hostom-addon'),
    ]
);

$layout_five_pricing_list->add_control(
    'plan_type',
    [
        'label' => __('Plan Type', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Starting', 'hostom-addon'),
    ]
);

$layout_five_pricing_list->add_control(
    'price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$50.00', 'hostom-addon'),
    ]
);

$layout_five_pricing_list->add_control(
    'duration',
    [
        'label' => __('Duration', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Per Month', 'hostom-addon'),
    ]
);


$layout_five_pricing_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li class="package-card__content__list__item">1 Website</li>', 'hostom_allowed_tags')
    ]
);

$layout_five_pricing_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Select Plan', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_five_pricing_list->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_five_pricing_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_five_pricing_list',
    [
        'label' => __('Pricing List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_pricing_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->end_controls_section();
