<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_two');

$this->add_control(
    'layout_two_enable_filter',
    [
        'label' => esc_html__('Enable Filter', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'hostom-addon'),
        'label_off' => esc_html__('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$filter = new \Elementor\Repeater();

$filter->add_control(
    'name',
    [
        'label' => __('Filter Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Name', 'hostom-addon'),
        'default' => __('Default Name', 'hostom-addon')
    ]
);

$filter->add_control(
    'slug',
    [
        'label' => __('Filter Slug', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Slug', 'hostom-addon'),
        'default' => __('default-slug', 'hostom-addon')
    ]
);

$this->add_control(
    'layout_two_filter',
    [
        'label' => __('Filter', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $filter->get_controls(),
        'title_field' => '{{{ name }}}',
        'condition' => [
            'layout_two_enable_filter' => 'yes'
        ]
    ]
);

$portfolio_two = new \Elementor\Repeater();

$portfolio_two->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($portfolio_two, 'Portfolio Title', 'h5', 'layout_two');

$portfolio_two->add_control(
    'slug',
    [
        'label' => __('Filter Slug', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Slug', 'hostom-addon'),
        'default' => __('default-slug', 'hostom-addon'),
        'label_block' => true
    ]
);


$portfolio_two->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Tag Line', 'hostom-addon'),
        'default' => __('Creative', 'hostom-addon'),
    ]
);

$portfolio_two->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$portfolio_two->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'portfolio_two_list',
    [
        'label' => __('Portfolio List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $portfolio_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
