<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Slider Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_sliders = new \Elementor\Repeater();

$layout_three_sliders->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($layout_three_sliders, 'Title', 'h2', 'layout_three');

$layout_three_sliders->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Sub Title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($layout_three_sliders, 'Sub Title', 'h5', 'layout_three');

$layout_three_sliders->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_three_sliders->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_three_sliders->add_control(
    'video_text',
    [
        'label' => __('Video Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Video Text', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_three_sliders->add_control(
    'video_url',
    [
        'label' => __('Video Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_three_sliders->add_control(
    'background_image_one',
    [
        'label' => __('Background Image One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_three_sliders->add_control(
    'background_image_two',
    [
        'label' => __('Background Image Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_three_sliders->add_control(
    'shape_one',
    [
        'label' => __('Shape One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'shape_two',
    [
        'label' => __('Shape Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'shape_three',
    [
        'label' => __('Shape Three', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'shape_four',
    [
        'label' => __('Shape Four', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'shape_five',
    [
        'label' => __('Shape Five', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'shape_six',
    [
        'label' => __('Shape Six', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_sliders',
    [
        'label' => __('Main Slider', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_sliders->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
