<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Slider Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$sliders = new \Elementor\Repeater();

$sliders->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($sliders, 'Title', 'h2', 'layout_one');

$sliders->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($sliders, 'SUb Title', 'h5', 'layout_one');


$sliders->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'hostom-addon'),
        'label_block' => true,
    ]
);

$sliders->add_control(
    'url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$sliders->add_control(
    'background_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$sliders->add_control(
    'shape_one',
    [
        'label' => __('Shape One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'sliders',
    [
        'label' => __('Main Slider', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $sliders->get_controls(),
        'title_field' => '{{{ title }}}',
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
