<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h5', 'layout_one');

$instagram_images = new \Elementor\Repeater();

$instagram_images->add_control(
    'image',
    [
        'label' => __('Add Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$instagram_images->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'gallery-one__card__icon',
            'library' => 'font-awesome',
        ],
    ]
);

$instagram_images->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'instagram_images',
    [
        'label' => __('Instagram Images', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $instagram_images->get_controls(),
    ]
);

$this->end_controls_section();
