<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('History Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_icon',
    [
        'label' => __('Section Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-star',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_two');


$history_two = new \Elementor\Repeater();

$history_two->add_control(
    'date',
    [
        'label' => __('Date', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Date', 'hostom-addon'),
        'default' => __('2023', 'hostom-addon'),
    ]
);

$history_two->add_control(
    'title_one',
    [
        'label' => __('Title One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title One', 'hostom-addon'),
        'default' => __('Default Title One', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($history_two, 'History Title One', 'h3', 'layout_two');

$history_two->add_control(
    'subtitle_one',
    [
        'label' => __('Subtitle One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Subtitle One', 'hostom-addon'),
        'default' => __('Default Subtitle One', 'hostom-addon'),
    ]
);

$history_two->add_control(
    'summary_one',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Summary', 'hostom-addon'),
        'default' => __('Default Summary', 'hostom-addon'),
    ]
);

$history_two->add_control(
    'image_one',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$history_two->add_control(
    'title_two',
    [
        'label' => __('Title Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title Two', 'hostom-addon'),
        'default' => __('Default Title Two', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($history_two, 'History Title Two', 'h3', 'layout_two');

$history_two->add_control(
    'subtitle_two',
    [
        'label' => __('Subtitle Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Subtitle Two', 'hostom-addon'),
        'default' => __('Default Subtitle Two', 'hostom-addon'),
    ]
);

$history_two->add_control(
    'summary_two',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Summary Two', 'hostom-addon'),
        'default' => __('Default Summary Two', 'hostom-addon'),
    ]
);

$history_two->add_control(
    'image_Two',
    [
        'label' => __('Image Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->add_control(
    'history_two_list',
    [
        'label' => __('History List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $history_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ date }}}',
    ]
);

$this->end_controls_section();
