<?php

$this->start_controls_section(
    'logo_section',
    [
        'label' => __('Site Logo', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'light_logo',
    [
        'label' => __('Light Logo', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'logo_dimension',
    [
        'label' => __('Logo Dimension', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
        'description' => __('Set Custom Logo Size.', 'hostom-addon'),
        'default' => [
            'width' => '181',
            'height' => '54',
        ],
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'nav_section',
    [
        'label' => __('Navigation', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'nav_menu',
    [
        'label' => __('Select Nav Menu', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => hostom_get_nav_menu(),
        'label_block' => true,
    ]
);

$this->add_control(
    'onepage_menu',
    [
        'label' => esc_html__('Onepage Menu', 'textdomain'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Show', 'textdomain'),
        'label_off' => esc_html__('Hide', 'textdomain'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->end_controls_section();

//top bar
$this->start_controls_section(
    'topbar_section',
    [
        'label' => __('Topbar', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$topbar_infos = new \Elementor\Repeater();

$topbar_infos->add_control(
    'topbar_icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-map-pin',
            'library' => 'custom',
        ],
        'label_block' => true,
    ]
);

$topbar_infos->add_control(
    'topbar_info_text',
    [
        'label' => __('Topbar Right Info Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('<span class="topbar-one__info__item__location">30 Commercial Road Fratton, Australia </span>', 'hostom-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'topbar_infos',
    [
        'label' => __('Topbar Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $topbar_infos->get_controls(),
        'title_field' => '{{{ topbar_info_text }}}',
        'prevent_empty' => false,
    ]
);


$this->end_controls_section();

//other
$this->start_controls_section(
    'others_section',
    [
        'label' => __('Others', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'search_enable',
    [
        'label' => __('Enable Search?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'cart_enable',
    [
        'label' => __('Enable Cart?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'default' => __('Contact Now', 'hostom-addon'),
        'label_block' => true,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_five']
        ],
    ]
);

$this->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_five']
        ],
    ]
);

$this->add_control(
    'call_text',
    [
        'label' => __('Call Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'default' => __('Call Text', 'hostom-addon'),
        'label_block' => true,
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four']
        ],
    ]
);

$this->add_control(
    'call_number',
    [
        'label' => __('Call Number', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'default' => __('(303) 555-0105', 'hostom-addon'),
        'label_block' => true,
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four']
        ],
    ]
);

$this->add_control(
    'call_url',
    [
        'label' => __('Call Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'default' => __('#', 'hostom-addon'),
        'label_block' => true,
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four']
        ],
    ]
);

$this->add_control(
    'call_icon',
    [
        'label' => __('Call Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-call-2',
            'library' => 'custom-icon',
        ],
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four']
        ],
    ]
);

$this->add_control(
    'header_topbar_navmenu_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);


$social_icons = new \Elementor\Repeater();

$social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'social_icons',
    [
        'label' => __('Social Icons', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $social_icons->get_controls(),
        'prevent_empty' => false,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']
        ],
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->add_control(
    'shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
        'condition' => [
            'layout_type' => 'layout_one'
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'mobile_menu_section',
    [
        'label' => __('Mobile Drawer', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'mobile_menu_logo',
    [
        'label' => __('Mobile Drawer Logo', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'mobile_email',
    [
        'label' => __('Email', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Email', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'mobile_phone',
    [
        'label' => __('Phone', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Phone Number', 'hostom-addon'),
        'label_block' => true,
    ]
);

$mobile_menu_social_icons = new \Elementor\Repeater();

$mobile_menu_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => hostom_get_fa_icons(),
        'default' => 'fa-facebook-f',
        'label_block' => true,
    ]
);

$mobile_menu_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'mobile_menu_social_icons',
    [
        'label' => __('Social Icons', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $mobile_menu_social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_icon' => 'fa-facebook-f',
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
        'title_field' => '{{{ social_icon }}}',
    ]
);

$this->end_controls_section();
