<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Gallery Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_projects_filter = new \Elementor\Repeater();

$layout_two_projects_filter->add_control(
    'name',
    [
        'label' => __('Filter Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Name', 'hostom-addon'),
        'default' => __('Default Name', 'hostom-addon')
    ]
);

$layout_two_projects_filter->add_control(
    'slug',
    [
        'label' => __('Filter Slug', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Slug', 'hostom-addon'),
        'default' => __('default-slug', 'hostom-addon')
    ]
);

$this->add_control(
    'layout_two_projects_filter',
    [
        'label' => __('Filter', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $layout_two_projects_filter->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);


$layout_two_projects = new \Elementor\Repeater();

$layout_two_projects->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_projects->add_control(
    'slug',
    [
        'label' => __('Slug List', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('default-slug', 'slando-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'gallery_list_two',
    [
        'label' => __('Galleries', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_projects->get_controls(),
        'prevent_empty' => false,
        'default' => [],
    ]

);

$this->end_controls_section();
