<?php

$this->start_controls_section(
    'content_section_four',
    [
        'label' => __('Gallery Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);

$this->add_control(
    'layout_four_enable_filter',
    [
        'label' => esc_html__('Enable Filter', 'pitoon-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'pitoon-addon'),
        'label_off' => esc_html__('No', 'pitoon-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$layout_four_projects_filter = new \Elementor\Repeater();

$layout_four_projects_filter->add_control(
    'name',
    [
        'label' => __('Filter Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Name', 'hostom-addon'),
        'default' => __('Default Name', 'hostom-addon')
    ]
);

$layout_four_projects_filter->add_control(
    'slug',
    [
        'label' => __('Filter Slug', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Slug', 'hostom-addon'),
        'default' => __('default-slug', 'hostom-addon')
    ]
);

$this->add_control(
    'layout_four_projects_filter',
    [
        'label' => __('Filter', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $layout_four_projects_filter->get_controls(),
        'title_field' => '{{{ name }}}',
        'condition' => [
            'layout_four_enable_filter' => 'yes',
            'layout_type' => 'layout_four'
        ]
    ]
);



$layout_four_projects = new \Elementor\Repeater();

$layout_four_projects->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_four_projects->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'gallery-one__card__icon',
            'library' => 'font-awesome',
        ],
    ]
);

$layout_four_projects->add_control(
    'slug',
    [
        'label' => __('Slug List', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('default-slug', 'slando-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'gallery_list_four',
    [
        'label' => __('projects', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_projects->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'title' => esc_html__('Title', 'hostom-addon'),
            ]
        ],
    ]

);

$this->end_controls_section();
