<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$counter_list = new \Elementor\Repeater();

$counter_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => wp_kses(__('Happy <br> User', 'hostom-addon'), 'hostom_allowed_tags')
    ]
);

$counter_list->add_control(
    'number',
    [
        'label' => __('Number', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Number', 'hostom-addon'),
        'default' => __('680', 'hostom-addon'),
        'label_block' => true
    ]
);

$counter_list->add_control(
    'symbol',
    [
        'label' => __('Symbol', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Symbol', 'hostom-addon'),
        'default' => __('K', 'hostom-addon'),
        'label_block' => true
    ]
);

$counter_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'funfact_list',
    [
        'label' => __('Funfact List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $counter_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
