<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_mailchimp_url',
    [
        'label' => __('Add Mailchimp URL', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
        'label_block' => true
    ]
);

$this->add_control(
    'layout_three_mc_input_placeholder',
    [
        'label' => __('Input Placeholder Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Email address', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_three_btn_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Subscribe', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_three_bottom_text',
    [
        'label' => __('Bottom Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_three_contact_list = new \Elementor\Repeater();

$layout_three_contact_list->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'rows' => '2',
        'placeholder' => __('Add Content', 'hostom-addon'),
        'default' => __('<span class="footer-widget__info__item__text">6391 Elgin St. Celina, Delaware 10299</span>', 'hostom-addon'),
    ]
);

$layout_three_contact_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-map-pin',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_contact_list',
    [
        'label' => __('Contact Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_contact_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ content }}}',
    ]
);

$this->end_controls_section();
