<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Gallery', 'hostom-addon')
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');


$footer_gallery_list = new \Elementor\Repeater();

$footer_gallery_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$footer_gallery_list->add_control(
    'icon',
    [
        'label' => __('Check Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-instagram',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'footer_gallery_list',
    [
        'label' => __('Gallery List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $footer_gallery_list->get_controls(),
        'prevent_empty' => false,
    ]
);


$this->end_controls_section();
