<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'text',
    [
        'label' => __('Add Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Content', 'hostom-addon')
    ]
);

$footer_contact_list = new \Elementor\Repeater();

$footer_contact_list->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Content', 'hostom-addon'),
        'default' => __('<a href="tel:+8801775-338747">(303) 555-0105</a>', 'hostom-addon'),
    ]
);

$footer_contact_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'footer_contact_list',
    [
        'label' => __('Contact Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $footer_contact_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ content }}}',
    ]
);

$this->end_controls_section();
