<?php

//content
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_two');


$this->end_controls_section();

$this->start_controls_section(
    'layout_two_content_faq_left',
    [
        'label' => __('Faq Left', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_left_faq = new \Elementor\Repeater();

$layout_two_left_faq->add_control(
    'question',
    [
        'label' => __('Question', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Question', 'hostom-addon'),
        'default' => __('Default Question', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_two_left_faq, 'Question Left Title', 'h4', 'layout_two');

$layout_two_left_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Answer', 'hostom-addon'),
        'default' => __('Default Answer', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_left_faq_lists',
    [
        'label' => __('FAQ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_left_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_two_content_faq_right',
    [
        'label' => __('Faq Right', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_right_faq = new \Elementor\Repeater();

$layout_two_right_faq->add_control(
    'question',
    [
        'label' => __('Question', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Question', 'hostom-addon'),
        'default' => __('Default Question', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_two_right_faq, 'Question Right Title', 'h4', 'layout_two');

$layout_two_right_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Answer', 'hostom-addon'),
        'default' => __('Default Answer', 'hostom-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_two_right_faq_lists',
    [
        'label' => __('FAQ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_right_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->end_controls_section();
