<?php

$this->start_controls_section(
    'layout_three_content_faq_left',
    [
        'label' => __('Faq', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_faq = new \Elementor\Repeater();

$layout_three_faq->add_control(
    'question',
    [
        'label' => __('Question', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Question', 'hostom-addon'),
        'default' => __('Default Question', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_three_faq, 'Question Title', 'h4', 'layout_three');

$layout_three_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Answer', 'hostom-addon'),
        'default' => __('Default Answer', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_three_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'layout_three_faq_lists',
    [
        'label' => __('FAQ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_three_content_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_thee_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_email_text',
    [
        'label' => __('Email Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_three_email_info',
    [
        'label' => __('Email Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Info', 'hostom-addon'),
        'default' => __('Sent to', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_three_email_address',
    [
        'label' => __('Email Address', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Info', 'hostom-addon'),
        'default' => __('needhelp@company.com', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->end_controls_section();
