<?php

$this->start_controls_section(
    'layout_four_content_faq_left',
    [
        'label' => __('Faq', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);

$layout_four_faq = new \Elementor\Repeater();

$layout_four_faq->add_control(
    'question',
    [
        'label' => __('Question', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Question', 'hostom-addon'),
        'default' => __('Default Question', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_four_faq, 'Question Title', 'h4', 'layout_four');

$layout_four_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Answer', 'hostom-addon'),
        'default' => __('Default Answer', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_four_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'layout_four_faq_lists',
    [
        'label' => __('FAQ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->end_controls_section();
