<?php

//content
$this->start_controls_section(
    'content_five',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);


$layout_five_faq = new \Elementor\Repeater();

$layout_five_faq->add_control(
    'question',
    [
        'label' => __('Question', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Question', 'hostom-addon'),
        'default' => __('Default Question', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_five_faq, 'Question Title', 'h4', 'layout_five');

$layout_five_faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Answer', 'hostom-addon'),
        'default' => __('Default Answer', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_five_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'layout_five_faq_lists',
    [
        'label' => __('FAQ List', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->end_controls_section();

//content
$this->start_controls_section(
    'layout_five_content_image',
    [
        'label' => __('Images', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);

$this->add_control(
    'layout_five_image_caption',
    [
        'label' => __('Image Caption', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Image Caption', 'hostom-addon'),
        'default' => __('Default Text', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_five_email_info',
    [
        'label' => __('Email Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Email Info', 'hostom-addon'),
        'default' => __('Sent to', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_five_email_address',
    [
        'label' => __('Email Address', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Email Address', 'hostom-addon'),
        'default' => __('needhelp@company.com', 'hostom-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_five_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
