<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_domain_placeholder',
    [
        'label' => __('Domain Placeholder', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Placeholder', 'hostom-addon'),
        'default' => __('domain.com', 'hostom-addon'),
    ]
);

$layout_two_domain_info = new \Elementor\Repeater();

$layout_two_domain_info->add_control(
    'tlds',
    [
        'label' => __('TLDs', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('.com', 'hostom-addon'),
    ]
);

$layout_two_domain_info->add_control(
    'price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Price', 'hostom-addon'),
        'default' => __('$8.55', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_two_domain_info',
    [
        'label' => __('Domain Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_domain_info->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ tlds }}}',
    ]
);

$this->add_control(
    'layout_two_bg_shape',
    [
        'label' => __('Background Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);


$this->end_controls_section();
