<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);


$this->add_control(
    'layout_three_domain_placeholder',
    [
        'label' => __('Domain Placeholder', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Placeholder', 'hostom-addon'),
        'default' => __('domain.com', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_btn_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Button Label', 'hostom-addon'),
        'default' => __('Search', 'hostom-addon'),
    ]
);

$layout_three_domain_info = new \Elementor\Repeater();

$layout_three_domain_info->add_control(
    'tlds',
    [
        'label' => __('TLDs', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('.com', 'hostom-addon'),
    ]
);

$layout_three_domain_info->add_control(
    'price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Price', 'hostom-addon'),
        'default' => __('$8.55', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_domain_info',
    [
        'label' => __('Domain Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_domain_info->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ tlds }}}',
    ]
);

$layout_three_images = new \Elementor\Repeater();

$layout_three_images->add_control(
    'rating',
    [
        'label' => __('Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Rating', 'hostom-addon'),
        'default' => __('4.6/5', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_three_images->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_images->add_control(
    'icon',
    [
        'label' => __('Rating Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-star',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_images',
    [
        'label' => __('Images', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_images->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
