<?php

$this->start_controls_section(
    'content_top_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Do you still<br> have questions?', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Call Anytime<a href="tel:+9288009850">+92 (8800) - 9850</a>', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-call-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'about_two_summary_hr',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$layout_one_info_items = new \Elementor\Repeater();

$layout_one_info_items->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Write email', 'hostom-addon'),
        'label_block' => true,
    ]
);

$layout_one_info_items->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => wp_kses(__('<a href="mailto:needhelp@company.com">needhelp@company.com</a>'), 'hostom_allowed_tags')
    ]
);

$layout_one_info_items->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-mailbox',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_info_items',
    [
        'label' => __('Contact Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_info_items->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
