<?php

$this->start_controls_section(
    'layout_two_contact_form',
    [
        'label' => __('Contact Form', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_two');


$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_two');


$this->add_control(
    'layout_two_select_wpcf7_form',
    [
        'label'       => esc_html__('Select your contact form 7', 'hostom-addon'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => hostom_post_query('wpcf7_contact_form'),
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_two_contact_info',
    [
        'label' => __('Contact Info', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_contact_title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title', 'hostom-addon'),
        'default' => __('Have Question?', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_two_contact_sub_title',
    [
        'label' => __('Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Sub Title', 'hostom-addon'),
        'default' => __('Contact us!', 'hostom-addon'),
    ]
);

$layout_two_contact_list = new \Elementor\Repeater();

$layout_two_contact_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title', 'hostom-addon'),
        'default' => __('Have any question?', 'hostom-addon'),
    ]
);

$layout_two_contact_list->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Content', 'hostom-addon'),
        'default' => __('<a href="tel:+92(8800)-8960">Free + 23 (000)-8050</a>', 'hostom-addon'),
    ]
);

$layout_two_contact_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_two_contact_list',
    [
        'label' => __('Contact Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_contact_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ content }}}',
    ]
);

$this->add_control(
    'layout_two_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
