<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Title', 'h2', 'layout_three');


$this->add_control(
    'layout_three_button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Get In Touch', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$this->add_control(
    'layout_three_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);


$this->end_controls_section();
