<?php
$this->start_controls_section(
    'header_title',
    [
        'label' => __('Blog Header', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_seven']
        ]
    ]
);


$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');


$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_one');

$this->end_controls_section();

$this->start_controls_section(
    'post_option',
    [
        'label' => __('Post Options', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'post_count',
    [
        'label' => __('Number Of Posts', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 0,
                'max' => 15,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 6,
        ],
    ]
);

$this->add_control(
    'post_word_count',
    [
        'label' => __('Word Count In Excerpt', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 200,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 11,
        ],
        'condition' => [
            'layout_type' => ['layout_one', 'layout_four', 'layout_seven']
        ]
    ]
);

$this->add_control(
    'query_order',
    [
        'label' => __('Select Order', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => 'DESC',
        'options' => [
            'DESC' => __('DESC', 'hostom-addon'),
            'ASC' => __('ASC', 'hostom-addon'),
        ]
    ]
);

$this->add_control(
    'select_category',
    [
        'label' => __('Post Category', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => hostom_get_taxonoy('category'),
    ]
);

$this->add_control(
    'pagination_status',
    [
        'label' => __('Enable Pagination?', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'hostom-addon'),
        'label_off' => __('No', 'hostom-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'read_more',
    [
        'label' => __('Read More', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Read More', 'hostom-addon'),
        'label_block' => true,
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'layout_one_right_post_section',
    [
        'label' => __('Right Area Post', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'layout_one_right_post',
    [
        'label'       => esc_html__('Select Right Area Post', 'hostom-addon'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => hostom_post_query('post'),
    ]
);

$this->add_control(
    'layout_one_custom_title',
    [
        'label' => __('Custom Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Custom Title', 'hostom-addon'),
        'default' => '',
    ]
);


$this->add_control(
    'layout_one_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
