<?php

$this->start_controls_section(
    'layout_four_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);


$this->add_control(
    'layout_four_title_first_part',
    [
        'label' => __('Title 1st Part', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Find Best Domain Here &', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_four_title_highlighted_text',
    [
        'label' => __('Title Highlighted Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Connect', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_four_title_last_part',
    [
        'label' => __('Title Last Part', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Connect', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Title', 'h2', 'layout_four');

$this->add_control(
    'layout_four_sub_title',
    [
        'label' => __('Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'hostom-addon'),
        'default' => __('Get Started Now', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Sub Title', 'h6', 'layout_four');

$this->add_control(
    'layout_four_button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Learn More', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_four_button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_four_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_four_shape_one',
    [
        'label' => __('Shape One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_four_shape_two',
    [
        'label' => __('Shape Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_four_shape_three',
    [
        'label' => __('Shape Three', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
