<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$award_list = new \Elementor\Repeater();

$award_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Best Counseling', 'hostom-addon'),
        'label_block' => true
    ]
);

hostom_elementor_heading_option($award_list, 'Title', 'h3', 'layout_one');

$award_list->add_control(
    'year',
    [
        'label' => __('Year', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add year text', 'hostom-addon'),
        'default' => __('2012', 'hostom-addon'),
        'label_block' => true
    ]
);

$award_list->add_control(
    'content',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'hostom-addon'),
        'default' => __('Default Summary', 'hostom-addon'),
    ]
);

$award_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-wreath',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'award_list',
    [
        'label' => __('Award Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $award_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_one_background_image',
    [
        'label' => __('Background Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_one_shape_one',
    [
        'label' => __('Shape One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_one_shape_two',
    [
        'label' => __('Shape Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
