<?php

//content
$this->start_controls_section(
    'layout_six_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_six'
        ]
    ]
);

$this->add_control(
    'layout_six_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_six');

$this->add_control(
    'layout_six_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_six');

$this->add_control(
    'layout_six_summary',
    [
        'label' => __('Summary Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary Text', 'hostom-addon'),
        'default' => __('Default Summary Text', 'hostom-addon'),
    ]
);


$layout_six_feature_list = new \Elementor\Repeater();

$layout_six_feature_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_six_feature_list->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$layout_six_feature_list->add_control(
    'content',
    [
        'label' => __('Content', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Content', 'hostom-addon'),
        'default' => __('Default Content', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_six_feature_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-ssl-certificate-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_six_feature_list',
    [
        'label' => __('Features Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_six_feature_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'layout_six_section_image',
    [
        'label' => __('Images', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_six'
        ]
    ]
);

$this->add_control(
    'layout_six_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_six_images = new \Elementor\Repeater();

$layout_six_images->add_control(
    'rating',
    [
        'label' => __('Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Rating', 'hostom-addon'),
        'default' => __('4.6/5', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_six_images->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_six_images',
    [
        'label' => __('Features Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_six_images->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ rating }}}',
    ]
);


$this->end_controls_section();
