<?php

//content
$this->start_controls_section(
    'layout_seven_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_seven'
        ]
    ]
);

$this->add_control(
    'layout_seven_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_seven');

$this->add_control(
    'layout_seven_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_seven');


$this->add_control(
    'layout_seven_summary',
    [
        'label' => __('Summary Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary Text', 'hostom-addon'),
        'default' => __('Default Summary Text', 'hostom-addon'),
    ]
);



$layout_seven_feature_list = new \Elementor\Repeater();

$layout_seven_feature_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);


$layout_seven_feature_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-server-2',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_seven_feature_list',
    [
        'label' => __('Features Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_seven_feature_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$layout_seven_porogressbar_list = new \Elementor\Repeater();

$layout_seven_porogressbar_list->add_control(
    'title',
    [
        'label' => __('Progressbar Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Progressbar Text', 'hostom-addon'),
        'default' => __('Default Progressbar Text', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_seven_porogressbar_list->add_control(
    'count',
    [
        'label' => __('Progressbar Count', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 75,
        ],
    ]
);

$this->add_control(
    'layout_seven_porogressbar_list',
    [
        'label' => __('Progressbar Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_seven_porogressbar_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_seven_section_image',
    [
        'label' => __('Images', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_seven'
        ]
    ]
);

$this->add_control(
    'layout_seven_image_one',
    [
        'label' => __('Image One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_seven_image_two',
    [
        'label' => __('Image Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_logo',
    [
        'label' => __('Logo', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_bg_shape',
    [
        'label' => __('Background Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
