<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_one');

$this->add_control(
    'summary',
    [
        'label' => __('Summary ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'hostom-addon'),
        'default' => __('Default Summary Text', 'hostom-addon'),
    ]
);

$layout_one_check_list = new \Elementor\Repeater();

$layout_one_check_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);


$this->add_control(
    'layout_one_check_list',
    [
        'label' => __('Check Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_check_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'about_one_images',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'layout_one_domain_info',
    [
        'label' => __('Domain Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('.com', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_domain_name',
    [
        'label' => __('Domain Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('domain', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_domain_price',
    [
        'label' => __('Domain Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('$30 only', 'hostom-addon'),
        'label_block' => true,
    ]
);


$layout_one_images = new \Elementor\Repeater();

$layout_one_images->add_control(
    'rating',
    [
        'label' => __('Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Rating', 'hostom-addon'),
        'default' => __('4.6/5', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_one_images->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_one_images->add_control(
    'icon',
    [
        'label' => __('Rating Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-star',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_images',
    [
        'label' => __('Images', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_images->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_image_one',
    [
        'label' => __('Images', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'layout_one_image',
    [
        'label' => __('Image One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_one_image_two',
    [
        'label' => __('Image Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_one_call_text',
    [
        'label' => __('Call Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Call Anytime', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_call_number',
    [
        'label' => __('Call Number', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('(303) 555-0105', 'hostom-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_call_url',
    [
        'label' => __('Call Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('#', 'hostom-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_one_call_icon',
    [
        'label' => __('Call Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->end_controls_section();
