<?php

//content
$this->start_controls_section(
    'layout_nine_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_nine'
        ]
    ]
);

$this->add_control(
    'layout_nine_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_nine');

$this->add_control(
    'layout_nine_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_nine');


$this->add_control(
    'layout_nine_summary',
    [
        'label' => __('Summary Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary Text', 'hostom-addon'),
        'default' => __('Default Summary Text', 'hostom-addon'),
    ]
);

$layout_nine_check_list = new \Elementor\Repeater();

$layout_nine_check_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_check_list',
    [
        'label' => __('Check Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_nine_check_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_nine_domain_info',
    [
        'label' => __('Domain Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Domain Info', 'hostom-addon'),
        'default' => __('<span>.com</span><span>domain</span>', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_domain_price',
    [
        'label' => __('Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Price', 'hostom-addon'),
        'default' => __('$30 only', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_nine_images = new \Elementor\Repeater();

$layout_nine_images->add_control(
    'rating',
    [
        'label' => __('Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Rating', 'hostom-addon'),
        'default' => __('4.6/5', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_nine_images->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->add_control(
    'layout_nine_images',
    [
        'label' => __('Image Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_nine_images->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ rating }}}',
    ]
);

$this->add_control(
    'layout_nine_btn_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Button Label', 'hostom-addon'),
        'default' => __('Learn more', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_btn_url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'layout_nine_section_image',
    [
        'label' => __('Images', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_nine'
        ]
    ]
);

$this->add_control(
    'layout_nine_call_text',
    [
        'label' => __('Call Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Call Text', 'hostom-addon'),
        'default' => __('Call Anytime', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_call_number',
    [
        'label' => __('Call Number', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Call Number', 'hostom-addon'),
        'default' => __('(303) 555-0105', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_call_url',
    [
        'label' => __('Call Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Call Url', 'hostom-addon'),
        'default' => __('#', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_nine_call_icon',
    [
        'label' => __('Call Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-1',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_nine_image_one',
    [
        'label' => __('Image One', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_nine_image_two',
    [
        'label' => __('Image Two', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->end_controls_section();
