<?php

/**
 * Template part for displaying Page Header
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package hostom
 */
?>
<?php
$hostom_page_header_extra_class = apply_filters('hostom_page_header_extra_class', 'page-header--unit-test');
?>
<section class="page-header">
	<div class="page-header__bg"></div>
	<!-- /.page-header__bg -->
	<div class="container">
		<?php
		$hostom_page_title_text = !empty(get_post_meta(get_the_ID(), 'hostom_set_header_title', true)) ? get_post_meta(get_the_ID(), 'hostom_set_header_title', true) : get_the_title();
		$hostom_page_header_tag = apply_filters('hostom_page_header_tag', 'h2');
		?>
		<<?php echo esc_attr($hostom_page_header_tag); ?> class="page-header__title">
			<?php if (!is_page()) : ?>
				<?php hostom_page_title(); ?>
			<?php else : ?>
				<?php echo wp_kses($hostom_page_title_text, 'hostom_allowed_tags') ?>
			<?php endif; ?>
		</<?php echo esc_attr($hostom_page_header_tag); ?>>
		<?php $hostom_page_meta_breadcumb_status = empty(get_post_meta(get_the_ID(), 'hostom_show_page_breadcrumb', true)) ? 'on' : get_post_meta(get_the_ID(), 'hostom_show_page_breadcrumb', true); ?>
		<?php if (function_exists('bcn_display_list') && 'yes' == get_theme_mod('breadcrumb_opt', 'off') && 'on' == $hostom_page_meta_breadcumb_status) : ?>
			<ul class="nionx-breadcrumb list-unstyled ml-0">
				<?php bcn_display_list(); ?>
			</ul><!-- /.thm-breadcrumb list-unstyled -->
		<?php endif; ?>
	</div><!-- /.container -->
</section><!-- /.page-header -->