<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package hostom
 */
?>


<?php
$hostom_page_id     = get_queried_object_id();
$hostom_custom_footer_status = !empty(get_post_meta($hostom_page_id, 'hostom_custom_footer_status', true)) ? get_post_meta($hostom_page_id, 'hostom_custom_footer_status', true) : 'off';

$hostom_custom_footer_id = '';
if ((is_page() && 'on' === $hostom_custom_footer_status) || (is_singular('portfolio') && 'on' === $hostom_custom_footer_status) || (is_singular('service') && 'on' === $hostom_custom_footer_status) || (is_singular('team') && 'on' === $hostom_custom_footer_status)) {
    $hostom_custom_footer_id = get_post_meta($hostom_page_id, 'hostom_select_custom_footer', true);
} elseif ('yes' == get_theme_mod('footer_custom')) {
    $hostom_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
    $hostom_custom_footer_id = 'default_footer';
}

$hostom_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $hostom_custom_footer_id;
?>
<?php if ('default_footer' == $hostom_dynamic_footer) : ?>
    <div class="main-footer__bottom default-footer">
        <div class="container">
            <div class="main-footer__bottom__inner">
                <p class="main-footer__copyright">
                    <?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; All Copyright 2024 by Hostom', 'hostom')), 'hostom_allowed_tags'); ?>
                </p>
            </div><!-- /.main-footer__inner -->
        </div><!-- /.container -->
    </div>
<?php else : ?>
    <?php echo do_shortcode('[hostom-footer id="' . $hostom_dynamic_footer . '"]');
    ?>
<?php endif; ?>
