<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package hostom
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-one__item col-md-12' ); ?>>
	<div class="blog-card__two  wow fadeInUp" data-wow-duration='1500ms' data-wow-delay='100ms'>
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="blog-card__two__image">
				<a href="<?php the_permalink(); ?>" class="blog-card__two__image__item">
					<?php the_post_thumbnail( 'hostom_blog_770X450' ); ?>
				</a>
				<div class="blog-card__two__date">
					<?php echo wp_kses( hostom_get_blog_date(), 'hostom_allowed_tags' ); ?>
				</div><!-- /.blog-card__two__date -->
			</div><!-- /.blog-card__two__image -->
		<?php endif; ?>
		<div class="blog-card__two__content">
			<ul class="list-unstyled blog-card__two__meta ml-0">
				<li class="blog-card__two__meta__item">
					<?php hostom_posted_by(); ?>
				</li>
				<?php if ( ! empty( get_comments_number() ) ) : ?>
					<li class="blog-card__two__meta__item">
						<?php hostom_comment_count(); ?>
					</li>
				<?php endif; ?>
			</ul><!-- /.list-unstyled blog-card__two__meta -->
			<h3 class="blog-card__two__title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3><!-- /.blog-card__two__title -->
			<?php $hostom_excerpt_count = apply_filters( 'hostom_excerpt_count', 41 ); ?>
			<p class="blog-card__two__text"><?php hostom_excerpt( $hostom_excerpt_count ); ?> </p>
			<!-- /.blog-card__two-two__text -->
			<a href="<?php the_permalink(); ?>"
				class="blog-card__two__link hostom-btn"><?php esc_html_e( 'Read More', 'hostom' ); ?></a><!-- /.blog-card__two__link -->
		</div><!-- /.blog-card-two__content -->
	</div><!-- /.blog-card -->
</article><!-- #post-<?php the_ID(); ?> -->