<?php

/**
 * hostom functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package hostom
 */

if (!function_exists('hostom_theme_customizer_styles')) :
	function hostom_theme_customizer_styles()
	{

		// hostom color option

		$hostom_inline_style = '';
		$hostom_inline_style .= ':root {
			' . hostom_source_color_meta('get') . '
		}';

		$hostom_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$hostom_inline_style .= '.page-header__bg { background-image: url(' . $hostom_inner_banner_bg . '); } ';

		$hostom_inner_banner_shape_two = get_theme_mod('page_header_shape_two');
		$hostom_inline_style .= '.page-header__bg::before { background-image: url(' . $hostom_inner_banner_shape_two . '); } ';

		$hostom_preloader_icon = get_theme_mod('preloader_image');
		if ($hostom_preloader_icon) {
			$hostom_inline_style .= '.preloader .preloader__image { background-image: url(' . $hostom_preloader_icon . '); } ';
		}

		if (is_page()) {
			$hostom_page_header_bg = empty(get_post_meta(get_the_ID(), 'hostom_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'hostom_set_header_image', true);

			$hostom_inline_style .= '.page-header__bg { background-image: url(' . $hostom_page_header_bg . '); }';
		}

		if (is_singular('post')) {
			$hostom_post_header_bg = empty(get_post_meta(get_the_ID(), 'hostom_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'hostom_set_header_image', true);

			$hostom_inline_style .= '.page-header__bg  { background-image: url(' . $hostom_post_header_bg . '); }';
		}


		wp_add_inline_style('hostom-style', $hostom_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'hostom_theme_customizer_styles', 991);
