<?php
function hostom_demo_import() {
	return array(
		array(
			'import_file_name' => 'Hostom Demo Import',
			'categories' => array( 'hostom' ),
			'local_import_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/sample-data.xml',
			'local_import_widget_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer.dat',
			'import_notice' => esc_html__( 'Please keep patients while importing sample data.', 'hostom' ),
		),
	);
}
add_filter( 'pt-ocdi/import_files', 'hostom_demo_import' );

function hostom_after_import_setup() {
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
		'menu-1' => $main_menu->term_id
	) );

	// Assign front page and posts page (blog page).
	$front_page_id = hostom_get_page_by_title( 'Home One' );
	$blog_page_id = hostom_get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	//woocommerce
	$woocommerce_shop = hostom_get_page_by_title( 'Hostom Shop' );
	$woocommerce_checkout = hostom_get_page_by_title( 'Hostom Checkout' );
	$woocommerce_cart = hostom_get_page_by_title( 'Hostom Cart' );
	$woocommerce_myaccount = hostom_get_page_by_title( 'Hostom My Account' );

	update_option( 'woocommerce_cart', $woocommerce_cart->ID );
	update_option( 'woocommerce_checkout_page_id', $woocommerce_checkout->ID );
	update_option( 'woocommerce_cart_page_id', $woocommerce_cart->ID );
	update_option( 'woocommerce_myaccount_page_id', $woocommerce_myaccount->ID );
	update_option( 'woocommerce_shop_page_id', $woocommerce_shop->ID );

	//Get entire array
	$woosq_settings = get_option( 'woosq_settings' );

	$woosq_settings['button_type'] = 'button';
	$woosq_settings['button_icon'] = 'only';
	$woosq_settings['button_position'] = '0';

	$woosw_settings = get_option( 'woosw_settings' );

	$woosw_settings['button_type'] = 'link';
	$woosw_settings['button_icon'] = 'right';
	$woosw_settings['button_position_archive'] = '0';
	$woosw_settings['button_position_single'] = '0';

	update_option( 'woosq_settings', $woosq_settings );
	update_option( 'woosw_settings', $woosw_settings );

	/**
	 * Replace URLs in content created with Elementor
	 */
	if ( class_exists( '\Elementor\Plugin' ) ) {


		global $wpdb;
		$old_url = 'https://hostomwp.pixydrops.com';
		$new_url = get_site_url();
		$escaped_from = str_replace( '//', '\/\/', $old_url );
		$escaped_to = str_replace( '//', '\/\/', $new_url );
		$meta_value_like = '[%'; // meta_value LIKE '[%' are json formatted

		$rows_affected = $wpdb->query(
			$wpdb->prepare(
				"UPDATE {$wpdb->postmeta} " .
				'SET meta_value = REPLACE(meta_value, %s, %s) ' .
				"WHERE meta_key = '_elementor_data' AND meta_value LIKE %s;",
				$escaped_from,
				$escaped_to,
				$meta_value_like
			)
		);

		if ( false === $rows_affected ) {
			throw new \Exception( 'An error occurred while replacing URL\'s.' );
		}

		// Allow externals to replace-urls, when they have to.
		$rows_affected += (int) apply_filters( 'elementor/tools/replace-urls', 0, $old_url, $new_url );

		\Elementor\Plugin::$instance->files_manager->clear_cache();
	}
}
add_action( 'pt-ocdi/after_import', 'hostom_after_import_setup' );
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
