<?php
/**
 * Trait Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Traits\Model_Param_Tools_Trait
 *
 * @since 0.7.0
 * @package ai-services
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Traits;

use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\API\Types\Tools;
use InvalidArgumentException;

/**
 * Trait for a model that uses `Tools`.
 *
 * @since 0.7.0
 */
trait Model_Param_Tools_Trait {

	/**
	 * The tools instance.
	 *
	 * @since 0.7.0
	 * @var Tools|null
	 */
	private $tools;

	/**
	 * Gets the tools instance.
	 *
	 * @since 0.7.0
	 *
	 * @return Tools|null The tools instance, or null if not set.
	 */
	final protected function get_tools(): ?Tools {
		return $this->tools;
	}

	/**
	 * Sets the tools instance.
	 *
	 * @since 0.7.0
	 *
	 * @param Tools $tools The tools instance.
	 */
	final protected function set_tools( Tools $tools ): void {
		$this->tools = $tools;
	}

	/**
	 * Sets the tools instance if provided in the `tools` model parameter.
	 *
	 * @since 0.7.0
	 *
	 * @param array<string, mixed> $model_params The model parameters.
	 *
	 * @throws InvalidArgumentException Thrown if the `tools` model parameter is invalid.
	 */
	protected function set_tools_from_model_params( array $model_params ): void {
		if ( ! isset( $model_params['tools'] ) ) {
			return;
		}

		if ( is_array( $model_params['tools'] ) ) {
			$model_params['tools'] = Tools::from_array( $model_params['tools'] );
		}

		if ( ! $model_params['tools'] instanceof Tools ) {
			throw new InvalidArgumentException(
				sprintf(
					'Invalid tools model parameter: The value must be an array or an instance of %s.',
					Tools::class
				)
			);
		}

		$this->set_tools( $model_params['tools'] );
	}
}
